/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.tools.Util;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;

public class BuilderCheckCode
extends Builder {
    protected int nbFile = 0;
    protected String format;
    protected String hipsCheckCode;
    long hipsEstsize = 0L;
    int hipsNbTiles;

    public BuilderCheckCode(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CHECKCODE;
    }

    @Override
    public void run() throws Exception {
        this.hipsCheckCode = this.context.getCheckCode();
        StringBuilder r = null;
        Tok tok = new Tok(this.format, " ,");
        while (tok.hasMoreTokens()) {
            String fmt = tok.nextToken();
            Info info = this.scanDir(new File(this.context.getOutputPath()), fmt);
            if (r == null) {
                r = new StringBuilder();
            } else {
                r.append(' ');
            }
            r.append(fmt + ":" + info.getCode());
            this.hipsEstsize += info.length;
            this.hipsNbTiles += info.n;
        }
        this.context.info("Full HiPS size: " + Util.getUnitDisk(this.hipsEstsize));
        this.context.info("Check codes: " + r);
        if (this.context.getCheckForce() || this.hipsCheckCode == null) {
            this.context.setCheckCode(r.toString());
            this.context.info("Check codes and HiPS metrics stored/updated in properties file");
            this.context.setPropriete("hips_estsize", this.hipsEstsize / 1024L + "");
            this.context.setPropriete("hips_nb_tiles", this.hipsNbTiles + "");
            this.context.writePropertiesFile();
        }
    }

    public Info scanDir(File dir, String fmt) throws Exception {
        this.context.info("Scanning " + fmt + " tiles...");
        Info info = new Info(fmt);
        this.scanDir(dir, fmt, info);
        this.context.info(info.n + " " + fmt + " files for " + Util.getUnitDisk(info.length));
        String flagOk = "";
        if (this.hipsCheckCode != null) {
            String v = Context.getCheckCode(fmt, this.hipsCheckCode);
            flagOk = info.getCode().equals(v) ? " => identical" : " => modified";
        }
        this.context.info("Check code for " + fmt + " tiles: " + info.getCode() + flagOk);
        return info;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.context.loadProperties();
        this.format = this.context.prop.getProperty("hips_tile_format");
        if (this.format == null) {
            this.format = this.context.prop.getProperty("format");
        }
        if (this.format == null) {
            throw new Exception("Out dir not a HiPS (or properties file missing)");
        }
        this.format = this.format.replace("jpeg", "jpg");
        String s = this.context.prop.getProperty("hips_check_code");
        this.context.setCheckCode(s);
        this.validateContextMore();
    }

    protected void validateContextMore() throws Exception {
        if (!this.context.getCheckForce()) {
            String string = this.context.getCheckCode();
        }
    }

    @Override
    public boolean isAlreadyDone() {
        return false;
    }

    @Override
    public void showStatistics() {
        if (this.context instanceof ContextGui) {
            return;
        }
        this.context.stat(this.nbFile + " file" + (this.nbFile > 1 ? "s" : "") + " scanned");
    }

    public boolean mustBeScanned(File f, String fmt) {
        String name = f.getName();
        if (!name.startsWith("Npix") && !name.startsWith("Allsky.")) {
            return false;
        }
        return name.endsWith("." + fmt);
    }

    public void scanDir(File dir, String fmt, Info info) throws Exception {
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (dir.isDirectory()) {
            Object[] list = dir.listFiles();
            Arrays.sort(list);
            for (Object f : list) {
                this.scanDir((File)f, fmt, info);
            }
            if (Files.isSymbolicLink(dir.toPath())) {
                Path target = Files.readSymbolicLink(dir.toPath());
                this.updateInfo(target.toFile(), info);
            }
        } else if (this.mustBeScanned(dir, fmt)) {
            this.updateInfo(dir, info);
            ++this.nbFile;
            this.context.setProgress(this.nbFile);
        }
    }

    protected void updateInfo(File f, Info info) throws Exception {
        long len = f.length();
        info.update(len);
    }

    class Info {
        String fmt;
        int n;
        long length;
        int code;
        ArrayList<File> corruptedFile = null;

        Info(String fmt) {
            this.fmt = fmt;
            this.code = 0;
            this.length = 0L;
        }

        void update(long v) {
            ++this.n;
            this.length += v;
            this.code = this.code * 31 + (int)(v ^ v >>> 32);
        }

        void addCorruptedFile(File f) {
            if (this.corruptedFile == null) {
                this.corruptedFile = new ArrayList();
            }
            this.corruptedFile.add(f);
        }

        String getCode() {
            return ((long)(this.code * 31 + this.n) & 0xFFFFFFFFL) + "";
        }
    }
}

